jQuery.noConflict();

(function($) {
	$(document).ready(function() {

		// =======================
		// Match Heights =========
		// =======================
		$('.service-carousel .item').matchHeight();
		$('.news .col .title').matchHeight();
		$('.news .col p').matchHeight();
		$('.case-study-list .col .title').matchHeight();
		$('.case-study-list .col p').matchHeight();
		$('.team-list .text.area').matchHeight();
		$('.service-list .item .area').matchHeight();
		$('.career-list .col .item').matchHeight();
		$('.form-info .item').matchHeight();
		$('.form-info .item').matchHeight();
		$('.news.list .text.area').matchHeight();
		$('.news.latest .text.area').matchHeight();
		

		// =======================
		// Carousels =============
		// =======================
		$(".main-banner-carousel").owlCarousel({
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1
		});

		$(".testimonials.carousel").owlCarousel({
			loop: true,
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1,
			stagePadding: 60,
			margin: 120
		});

		$(".timeline-carousel").owlCarousel({
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1,
			margin: 40,
			responsive: {
				0:{
					items: 1
				},
				768:{
					items: 2
				},
				1140:{
					items: 3
				}
			}
		});

		$(".service-carousel").owlCarousel({
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1,
			margin: 40,
			responsive: {
				0:{
					items: 1
				},
				768:{
					items: 2
				},
				1140:{
					items: 3
				},
				1200:{
					items: 4
				}
			}
		});

		$(".image-text-carousel").owlCarousel({
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1,
			margin: 40,
			stagePadding: 85,
			responsive: {
				0:{
					items: 1,
					stagePadding: 0
				},
				768:{
					stagePadding: 85
				},
				1024:{
					items: 2
				}
			}
		});

		$(".logo-carousel").owlCarousel({
			loop: true,
			nav: true,
			navText : ['<i class="fas fa-arrow-alt-circle-left"></i>','<i class="fas fa-arrow-alt-circle-right"></i>'],
			items: 1,
			margin: 40,
			stagePadding: 85,
			responsive: {
				0:{
					items: 2,
					stagePadding: 0
				},
				768:{
					items: 3,
					stagePadding: 85
				},
				1024:{
					items: 4
				},
				1400:{
					items: 5
				}
			}
		});


		// =======================
		// Fix for <select> arrow :before not being clickable
		// =======================
		$('.field.select, .FieldWrapper.select').click(function(){
			// alert('sdfs');
			// $('.internal-banner i').trigger('click');
			$(this).find('select').trigger('click');
		});

		    // $("#click").on('click', function() {
		    //     var $target = $("#ts");
		    //     var $clone = $target.clone().removeAttr('id');
		    //     $clone.val($target.val()).css({
		    //         overflow: "auto",
		    //         position: 'absolute',
		    //         'z-index': 999,
		    //         left: $target.offset().left,
		    //         top: $target.offset().top + $target.outerHeight(),
		    //         width: $target.outerWidth()
		    //     }).attr('size', $clone.find('option').length > 10 ? 10 : $clone.find('option').length).change(function() {
		    //         $target.val($clone.val());
		    //     }).on('click blur keypress',function(e) {
		    //      if(e.type !== "keypress" || e.which === 13)
		    //         $(this).remove();
		    //     });
		    //     $('body').append($clone);
		    //     $clone.focus();
		    // });




		// =======================
		// Mobile Nav ============
		// =======================

		// Nav button
		$('.mobile-nav-btn').click(function(){
			if ($(this).hasClass('close')) {
				$('.main-nav').slideUp();
				$('.mobile-nav-btn.close').fadeOut();
			} else {
				$('.main-nav').slideDown();
				$('.mobile-nav-btn.close').fadeIn();
			}
		});

		// Mobile menu
		$('.main-nav .item-with-dropdown i').click(function(){
			$(this).closest('.item-with-dropdown').find('.dropdown').slideToggle();
		});




		// =======================
		// Tabs ==================
		// =======================

		function createTabs(tabsClass, contentClass){
			$(tabsClass).click(function(){
				var tab_id = $(this).attr('data-tab');

				$(tabsClass).removeClass('current');
				$(this).addClass('current');

				$(contentClass).children().fadeOut(300, function(){
					$(this).parent().removeClass('current');
					$("#"+tab_id).addClass('current');
					$(this).fadeIn(300);
				});
			});
		}

		createTabs('');



		// =======================
		// Slide Ups for CTAs ====
		// =======================
		function createSlide(parent, topDistance){
			$(parent).each(function(){
				$(this).on({
					mouseenter: function(){
						$(this).find('.text-area').animate({'top':'0'}, 300);
						// $(this).find('.plus').addClass('hide');
						// $(this).find('.minus').removeClass('hide');
					},
					mouseleave: function(){
						$(this).find('.text-area').animate({'top':topDistance}, 300);
						// $(this).find('.minus').addClass('hide');
						// $(this).find('.plus').removeClass('hide');	
					}	
				});
			});
		}

		createSlide();



		// =======================
		// Casey Study List Filter
		// =======================
		$('.case-study-list .filter li').click(function(){

			var filterTerm = $(this).data('term');

			console.log('.' + filterTerm);

			$('.case-study-list .col').hide().removeClass('active');
			$('.case-study-list .col').filter('.' + filterTerm).show().addClass('active');
			$('.case-study-list .col.active').first().addClass('First');
		});



		// =======================
		// Click to scrolls ======
		// =======================
		$('.btn.apply').click(function(){
			$('html, body').animate({scrollTop: $(".form-info.map").offset().top - 200}, 500);
		});

		$('.internal-banner i').click(function(){
			$('html, body').animate({scrollTop: $(".internal-banner").offset().top + 400}, 500);
		});


		// =======================
		// Header search bar =====
		// =======================
		$('header .btn.search').click(function(){
			$('#form-search').slideToggle(300);
		});



		// =======================
		// Sticky header =========
		// =======================
		$(window).scroll(function(){
			if($(window).width() > 1024){
				if($(window).scrollTop() > 400){
					 $('.sticky-header').fadeIn();
				}
				else{
					 $('.sticky-header').fadeOut();
				}
			} 

			// else if ($(window).width() <= 1024) {
			// 	if($(window).scrollTop() > 400){
			// 		console.log('1');
			// 		 $('.sticky-header .main-nav').addClass('sticky');
			// 	}
			// 	else{
			// 		console.log('2');
			// 		 $('.sticky-header .main-nav').removeClass('sticky');
			// 	}
			// }
		});


	});
}(jQuery));
