<?php

namespace NewedgeMedia\MenuManager;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig_RelationEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\TextField;
use Page;
use Sheadawson\Linkable\Models\Link;
use Sheadawson\Linkable\Forms\LinkField;
use SilverStripe\Forms\CheckboxField;

class MenuCategory extends DataObject {

    private static $singular_name = "Menu Item";

	private static $db = array(
		"Name"          => "Varchar(100)",
		"SortOrder"     => "Int",
		// "Title"			=> "Text",
		// "ButtonText"	=> "Text",
		"External"      => "Boolean",
		"ExternalLink"      => "Text",		
	);

    private static $table_name = 'MenuCategory';
	
	private static $default_sort = "SortOrder";

	private static $has_one = array(
		"Menu"      	 => MenuItem::class,
		// "Image"     	 => Image::class,
		"TargetPage"     => SiteTree::class,
	);

    // private static $owns = [
    //     'Image'
    // ];	

    private static $many_many = array(
    ); 

	private static $has_many = array(
		// "ChildCategories"   => "MenuCategory"
		"MenuItems"         => MenuItem::class
	);

	public function getCMSFields()
	{
		$fields = parent::getCMSFields(); // TODO: Change the autogenerated stub
		$fields->removeByName("MenuItems");
		$fields->removeByName("SortOrder");
		// $fields->removeByName("Name");
		//Menu items
		$gridFieldConfig  = GridFieldConfig_RecordEditor::create();
		if ($this->ID > 0){
			$gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));    
		}		
		// $gridfield = new GridField("MenuItems", "MenuItems", $this->MenuItems(), $gridFieldConfig);
		// $fields->addFieldToTab("Root.MenuItems", $gridfield);

        //CTA
		$fields->addFieldToTab("Root.Main", new TextField("Name", "Title"));
		// $fields->addFieldToTab("Root.CTA", new UploadField("Image", "Image"));
		$fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
		$target->setEmptyString("Select a target page");
		// $fields->addFieldToTab("Root.CTA", new TextField("ButtonText", "Title"));
		// $fields->addFieldToTab('Root.Main', LinkField::create('TargetPageID', 'Link to page or file'));
		$fields->addFieldToTab("Root.Main", new CheckboxField("External", "Disable TargetPage and enable external link"));		
		$fields->addFieldToTab("Root.Main", new TextField("ExternalLink", "External Link"));		
		return $fields;
	}

    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    }
    public function canDelete($member = null, $context = array()){
        return true;
    }	
}