<?php

namespace NewedgeMedia\MenuManager;

use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\TextField;

class Menu extends DataObject {
	private static $db = array(
		"Name"  	=> "Varchar(100)",
		"Title"  	=> "Varchar(100)",
		"SortOrder" => "Int"
	);

	private static $has_many = array(
		"MenuItems" => MenuItem::class
	);

    private static $table_name = 'Menu';
	
    // private static $default_sort = "SortOrder";
    
	public function getCMSFields()
	{
		$fields = parent::getCMSFields(); // TODO: Change the autogenerated stub
		$fields->removeByName("LinkTracking");
		$fields->removeByName("SortOrder");
		$fields->removeByName("FileTracking");
		

		$fields->addFieldToTab("Root.Main", $Name        = TextField::create("Name"));
		if(!empty($this->Name)){ //if value is set then make field read only.
			$Name->setReadonly(true);
		}

		$fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

		$gridFieldConfig  = GridFieldConfig_RecordEditor::create();
		$gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
		$gridfield = new GridField("MenuItems", "MenuItems", $this->MenuItems(), $gridFieldConfig);
		$fields->addFieldToTab("Root.MenuItems", $gridfield);
		return $fields;
	}

	public function requireDefaultRecords(){
//		parent::requireDefaultRecords();
		foreach ($this->getConfigMenuLevels() as $name) {
			$existingRecord = Menu::get()->filter('Name', $name)->first();
			if (!$existingRecord) {
				$set = new Menu();
				$set->Name = $name;
				$set->write();
				DB::alteration_message("MenuLevel '$name' created", 'created');
			}
		}
	}

	public function getConfigMenuLevels(){
		return Menu::config()->menus ?: array();
	}

    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    }
    public function canDelete($member = null, $context = array()){
        return true;
    }

	public function isConfigLevel(){
		return in_array($this->Name, $this->getConfigMenuLevels());
	}
}