<?php
use SilverStripe\Forms\FieldList;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\ORM\DataExtension;
use SilverStripe\Assets\Image;

class ImagePlaceholderExtension extends DataExtension {
	private static $has_one = array(
		"PlaceholderImage"  => Image::class
	);

	private static $owns = [
		'PlaceholderImage'
	];	

	public function updateCMSFields(FieldList $fields)
	{
		$fields->addFieldToTab("Root.Images", new UploadField("PlaceholderImage"));
	}
}