<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\NumericField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;


class CustomSiteConfig extends DataExtension {
	private static $db = array(
		// "Email" 			=> "Text",
		// "Telephone" 		=> "Text",
		"Address" 			=> "HTMLText",
		"Sort"     			=> "Int",

		"HeaderButtonText1"	=> "Text",
		"HeaderButtonText2"	=> "Text",

	);

	private static $default_sort = "Sort";

	private static $has_one = array(
		"HeaderButton1"	=>	SiteTree::class,
		"HeaderButton2"	=>	SiteTree::class,
	);	

	private static $has_many = array(
		"SocialMediaLink"	=> SocialMediaLink::class,
	);

	public function updateCMSFields(FieldList $fields) {
		$fields->removeByName("Sort");

		if ($this->owner->ID > 0) {
			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$grid = new GridField("SocialMediaLink", "SocialMediaLink", $this->owner->SocialMediaLink(), $gridFieldConfig);
			$fields->addFieldToTab("Root.Social Media", $grid);
		}

		// $fields->addFieldToTab("Root.Contact", new TextField("Email", "Email"));
		// $fields->addFieldToTab("Root.Contact", new TextField("Telephone", "Telephone"));
		$fields->addFieldToTab("Root.Contact", new HTMLEditorField("Address", "Address"));

		$fields->addFieldToTab("Root.Header", new TextField("HeaderButtonText1", "Header Button 1"));
		$fields->addFieldToTab("Root.Header", $target = DropdownField::create("HeaderButton1ID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
		$target->setEmptyString("Select a target page");	

		$fields->addFieldToTab("Root.Header", new TextField("HeaderButtonText2", "Header Button 2"));
		$fields->addFieldToTab("Root.Header", $target = DropdownField::create("HeaderButton2ID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
		$target->setEmptyString("Select a target page");			

		return $fields;
	}
}