<?php

namespace NewedgeMedia\BlockBuilder;

use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldButtonRow;
use SilverStripe\Forms\GridField\GridFieldToolbarHeader;
use SilverStripe\Forms\GridField\GridFieldSortableHeader;
use SilverStripe\Forms\GridField\GridFieldFilterHeader;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use SilverStripe\Forms\GridField\GridFieldEditButton;
use SilverStripe\Forms\GridField\GridFieldDeleteAction;
use SilverStripe\Forms\GridField\GridFieldPageCount;
use SilverStripe\Forms\GridField\GridFieldPaginator;
use SilverStripe\Forms\GridField\GridFieldDetailForm;
/**
 * GridField config necessary for managing a SiteTree object.
 *
 * @package silverstripe
 * @subpackage blog
 *
 * @author Michael Strong <github@michaelstrong.co.uk>
**/
class GridFieldConfig_PageBlock extends GridFieldConfig {
	
	public function __construct($itemsPerPage = null) {
		parent::__construct($itemsPerPage);
//		$classes = ClassInfo::subclassesFor('PageBlock');
//		unset($classes['PageBlock']); // If you don't want 'MyDataObject' itself included
		$this->addComponent(new GridFieldButtonRow('before'));
//		$this->addComponent($multiField = new GridFieldAddNewMultiClass('buttons-before-left'));
//		$multiField->setClasses(array_values($classes));
		$this->addComponent(new GridFieldToolbarHeader());
		$this->addComponent($sort = new GridFieldSortableHeader());
		$this->addComponent($filter = new GridFieldFilterHeader());
		$this->addComponent(new GridFieldDataColumns());
		$this->addComponent(new GridFieldEditButton());
		$this->addComponent(new GridFieldDeleteAction());
		$this->addComponent(new GridFieldPageCount('toolbar-header-right'));
		$this->addComponent($pagination = new GridFieldPaginator($itemsPerPage));
		$this->addComponent(new GridFieldDetailForm());
		// $this->addComponent(new GridFieldEditableColumns());
		$pagination->setThrowExceptionOnBadDataType(true);
	}
}