<?php

namespace NewedgeMedia\BlockBuilder;

use SilverStripe\ORM\DataObject;
use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\RequiredFields;
use Psr\SimpleCache\CacheInterface;
use SilverStripe\Core\Injector\Injector;
use SilverStripe\ORM\ArrayList;
use SilverStripe\View\ArrayData;
use SilverStripe\Core\ClassInfo;
use SilverStripe\View\Requirements;

class BlockBuilder_Controller extends DataExtension {
	private static $allowed_actions = array (
		"BlockCss"
	);

    public function onAfterInit(){
        Requirements::css(BLOCK_BUILDER_DIR . "/css/wysiwyg.css");
        Requirements::css(BLOCK_BUILDER_DIR . "/css/blocks/BlockWidgetImageGallery.css");
    }

	public function BlockCss(){
		$this->owner->response->addHeader( 'Content-type', 'text/css' );
		$blocks = $this->getStyledBlocks();
		return $this->owner->renderWith('blockcss');
	}

	public function getStyledBlocks(){
//		$blocks = $this->getCachedBlocks();
		$blocks = $this->getFreshBlocks();
		$blockData = new ArrayList();
		foreach($blocks as $block){
			$blockData->push(
				new ArrayData(
					$block
				)
			);
		}
		return $blockData;
	}

	public function getCachedBlocks(){
		$cacheKey = "PageBlockCache";
		$cache = Injector::inst()->get(CacheInterface::class . '.PageBlocks');
		if (!$blocks = $cache->get($cacheKey)){
			$blocks = $this->getFreshBlocks();
			$cache->set($cacheKey, serialize($blocks));
		} else {
			$blocks = unserialize($blocks);
		}
		return $blocks;
	}

	public function getFreshBlocks(){
		$blocks = $this->getFreshBlockTypes();
		$blockCSS = array();
		foreach($blocks as $block){
			$CSSBlocks = $block::get();
			if ($CSSBlocks->Count() == 0){
				continue;
			}
			foreach($CSSBlocks as $CSSBlock){
				$newCSS = $CSSBlock->getCustomCSS();
				if (is_array($newCSS) && count($newCSS) > 0){
					foreach ($newCSS as $Key => $CSS){
						$blockCSS = array_merge($blockCSS, $CSS);
					}
				}
			}
		}
		return $blockCSS;
	}

	public function getFreshBlockTypes(){
		$blocks = new ArrayList();
		$BlockTypeList = ClassInfo::subClassesFor(PageBlock::class);
		foreach($BlockTypeList as $blockType){
			if (singleton($blockType)->config()->customCSS){
				$blocks->push($blockType);
			}
		}
		return $blocks;
	}
	
}