<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use UndefinedOffset\SortableGridField\Forms\GridFieldSortableRows;

class BlockWidgetImageGalleryItems extends DataObject
{
	private static $singular_name = "Image";

	private static $db = array(
		"Name" => "Text",
		"Sort"     => "Int"
	);

	private static $default_sort = "Sort";

	private static $has_one = array(
		 "GalleryImage"         => Image::class,
		 "BlockWidgetImageGallery"  => BlockWidgetImageGallery::class
	);

	private static $has_many = array(
	);

    private static $owns = [
        'GalleryImage'
    ];
    
	private static $summary_fields = array(
		"Name"  	=> "Name",
		"GridThumbnail" => "Image",
	);

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Sort");
		$fields->removeByName("BlockWidgetImageGalleryID");
		$fields->addFieldToTab("Root.Main", new TextField("Name", "Name"));
		$fields->addFieldToTab("Root.Main", new UploadField("GalleryImage", "Image"));
		return $fields;
	}

	public function getGridThumbnail(){
		return $this->GalleryImage()->Thumbnail(50,50);
	}
}