<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;

class BlockWidgetHeading extends PageBlock {

	private static $db = array(
		'Heading'		=> 'Varchar(255)',
		'HeadingClass'	=> "Enum(array('h1','h2','h3'))"
	);

    private static $table_name = 'BlockWidgetHeading';

    private static $has_one = array(
        "TitleImage"             => Image::class,
    );
    
    private static $owns = [
        'TitleImage'
    ];

	private static $singular_name = "Heading Block";

	public function CountTitle() {

		$PageBlock = $this->PageBlockRow()->Page();

		if(!empty($this->Heading)){
			$count = strlen($this->Heading);
		}else{
			$count = strlen($PageBlock->Title);
		}

		return $count;
		// echo '<pre>' . print_r($count, true) . '</pre>';die();
	}

	function getCMSFields() {
		$fields = parent::getCMSFields();
        $fields->removeByName("LinkTracking");
        $fields->removeByName("FileTracking");		

		// $fields->replaceField("Content", new HTMLEditorField("Content"));

		// $grid->getConfig()->getComponentByType('GridFieldDetailForm')->setValidator(singleton('BlockWidgetAccordionItem')->getCMSValidator()); 
		// $fields->addFieldToTab('Root.Main', $grid);

		return $fields;
	}
}