<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;

class BlockWidgetOurCapabilitiesItems extends DataObject {

    private static $singular_name = "Text Carousel Item";

    private static $db = array(
        "Title"          => "Varchar",
        "Content"        => "HTMLText",
        "ButtonText"     => "Varchar",
        "Sort"           => "Int",
    );

    private static $default_sort = "Sort";
    
    private static $allowed_page_types = array(
    );

    private static $has_many = array(
    );

    private static $defaults = array(
           'Title'      => "Enter a title in the CMS",
           'Content'    => "Accumsan tortor posuere ac ut consequat semper viverra nam. Ultrices dui sapien eget mi proin sed libero. Congue nisi vitae suscipit tellus mauris a. Scelerisque varius morbi enim nunc faucibus. Quam nulla porttitor massa id neque aliquam. Enim facilisis gravida neque convallis. Ut sem viverra aliquet eget sit amet. Habitant morbi tristique senectus et netus et malesuada fames ac. Mollis nunc sed id semper risus in. Porttitor massa id neque aliquam. Placerat duis ultricies lacus sed. Risus viverra adipiscing at in tellus integer. Et egestas quis ipsum suspendisse ultrices. Aliquet porttitor lacus luctus accumsan. Sit amet volutpat consequat mauris nunc congue.",         
           'ButtonText' => "Read more",        
    );

    private static $has_one = array(
        "BlockWidgetOurCapabilities"        => BlockWidgetOurCapabilities::class,
        "Image"                             => Image::class,
        "TargetPage"                        => SiteTree::class,
        "FontAwsomeIcon"                    => FontAwsomeIcon::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("BlockWidgetOurCapabilitiesID");
        $fields->removeByName("Sort");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Main', $field); 


        $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "Button Text"));

        $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
        $target->setEmptyString("Select a target page");

        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));

        $fields->addFieldToTab("Root.Main", new HTMLEditorField("Content", "Content"));


        return $fields;
    }

}
