<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;

use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
class BlockWidgetServiceCarousel extends PageBlock {

    private static $singular_name = "Service Carousel Block";

    private static $db = array(
        "Title"         => "Varchar",
    );

    private static $fullOnly = true;

    private static $allowed_page_types = array(
    );
    private static $has_many = array(
        "Items" => BlockWidgetServiceCarouselItems::class
    );

    private static $has_one = array(
    );

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("Items");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        if ($this->ID > 0){
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Main", $grid);
        }        
        return $fields;
    }

}
