<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\DropdownField;

class BlockWidgetImageTextIcon extends PageBlock {

    private static $singular_name = "Image Text Icon Block";

    private static $db = array(
        "Title"         => "Varchar",
        "Content"       => "HTMLText",
        "ButtonText"    => "Varchar",
        "Float"          => "Enum(array('Left','Right'))",

    );
    
    private static $defaults = array(
           'Title'      => "Enter a title in the CMS",
           'Content'    => "Accumsan tortor posuere ac ut consequat semper viverra nam. Ultrices dui sapien eget mi proin sed libero. Congue nisi vitae suscipit tellus mauris a. Scelerisque varius morbi enim nunc faucibus. Quam nulla porttitor massa id neque aliquam. Enim facilisis gravida neque convallis. Ut sem viverra aliquet eget sit amet. Habitant morbi tristique senectus et netus et malesuada fames ac. Mollis nunc sed id semper risus in. Porttitor massa id neque aliquam. Placerat duis ultricies lacus sed. Risus viverra adipiscing at in tellus integer. Et egestas quis ipsum suspendisse ultrices. Aliquet porttitor lacus luctus accumsan. Sit amet volutpat consequat mauris nunc congue.",         
           'ButtonText' => "Read more",        
    );

    public function getImageAlignment(){
        switch($this->Float){
            case "Left":
                return "Left";
            case "Right":
                return "Right";
        }
    }

    private static $fullOnly = true;

    private static $has_one = array(
        "FontAwsomeIcon"    => FontAwsomeIcon::class,
        "TargetPage"        => SiteTree::class,
        "Image"             => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("IconImage");
        $fields->removeByName("Sort");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        $fields->addFieldToTab('Root.Main', new DropdownField(
              'Float',
              'Image Position',
              singleton('BlockWidgetImageTextIcon')->dbObject('Float')->enumValues()
        ));        

        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Main', $field);        

        $HTML = HTMLEditorField::create('Content', 'Content')
            ->setRows(5);
        $fields->addFieldToTab('Root.Main', $HTML);

        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
        $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));        
        $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
        $target->setEmptyString("Select a target page");        
        return $fields;
    }

}
