<?php
use FormFields\BlockWidgetCustomisableForm;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\CheckboxField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class BlockWidgetContactInfoMap extends BlockWidgetCustomisableForm
{
	private static $singular_name = "Contact Info, Map & Form Block";

    private static $db = array(
        "InfoTitle"         => "Text",

        "Telephone"         => "Varchar(50)",
        "Email"             => "Varchar(50)",
        "Address"           => "Text",
        "Content"           => "HTMLText",

        "Enable"           => "Boolean",
        "Latitude"           => "Text",
        "Longitude"          => "Text",

        "ButtonTextTitle"   => "Varchar(50)",
    );

	private static $has_one = array(

    );

    private static $default_fields = array(
        "Your name"   => array(
            "FormFields\CustomisableTextField" => array(
               
            ),
        ),
        "Your email"   => array(
            "FormFields\CustomisableTextField" => array(
      
            ),
        ),
        "Your number"   => array(
            "FormFields\CustomisableNumericField" => array(

            ),
        ),
        "Subject of enquiry"   => array(
            "FormFields\CustomisableDropdownList" => array(

            ),
        ),        
        "Additional comments"   => array(
            "FormFields\CustomisableTextAreaField" => array(

            ),
        ),
     );


    public function getCMSFields()
    {
        $fields = parent::getCMSFields();
        $fields->removeByName("Content");
        $fields->addFieldToTab("Root.Info", new TextField("InfoTitle", "Title"));

        $fields->addFieldToTab("Root.Info", new TextField("Telephone", "Telephone"));
        $fields->addFieldToTab("Root.Info", new TextField("Email", "Email"));
        $fields->addFieldToTab("Root.Info", new TextField("Address", "Address"));
        $fields->addFieldToTab("Root.Info", new HtmlEditorField("Content", "Content"));
        
        $fields->addFieldToTab("Root.Info", new CheckboxField("Enable", "Enable map"));
        $fields->addFieldToTab("Root.Info", new TextField("Latitude", "Latitude"));
        $fields->addFieldToTab("Root.Info", new TextField("Longitude", "Longitude"));


        $fields->addFieldToTab("Root.Main", new TextField("ButtonTextTitle", "ButtonText"));
        return $fields;
    }

}