<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;

class ReCAPTCHAServiceSiteConfigExtension extends DataExtension {
	private static $db = array(
		"ReCAPTCHABackID"   => "Varchar(255)",
		"ReCAPTCHAFrontID"  => "Varchar(255)"
	);

	public function updateCMSFields(FieldList $fields)
	{
		$fields->addFieldToTab("Root.RECAPTCHA", new TextField("ReCAPTCHABackID", "ReCAPTCHA Server Side Site Key(secret)"));
		$fields->addFieldToTab("Root.RECAPTCHA", new TextField("ReCAPTCHAFrontID", "ReCAPTCHA Front End Site Key"));
		parent::updateCMSFields($fields); // TODO: Change the autogenerated stub
	}
}