<?php
    use SilverStripe\AssetAdmin\Forms\UploadField;
    use SilverStripe\Forms\TextField;
    use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
    use SilverStripe\CMS\Model\SiteTree;
    use SilverStripe\Forms\TreeDropdownField;
    use SilverStripe\Assets\Image;
    use SilverStripe\Security\Member;
    use SilverStripe\ORM\DataObject;
    use SilverStripe\Forms\DropdownField;
    use SilverStripe\Forms\CheckboxField;
    use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
    use SilverStripe\Forms\GridField\GridFieldConfig;
    use SilverStripe\Forms\GridField\GridField;
    use SilverStripe\Forms\GridField\GridFieldAddNewButton;
    use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
    use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
    use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
    use SilverStripe\Forms\Tab;
    use SilverStripe\Forms\ListboxField;

class StaffPage extends Page {

    private static $db = array(
        "FirstName"                 => "Text",
        "Surname"                   => "Text",
        "JobTitle"                  => "Text",
        "ContactEmail"              => "Text",
        "ContactNumber"             => "Text", 
        "AboutMe"                   => "HTMLText",        
    );

    private static $show_in_sitetree = false;

    private static $default_sort = 'Title ASC';

    private static $has_one = [
        "ProfileImage"  => Image::class,
    ];

    private static $has_many = array(
        "Responiblities"    => Responiblities::class
    );

    private static $many_many = array(
    );

    private static $belongs_many_many = array(
    );    

    private static $owns = [
        "ProfileImage",
    ];


    public function getCMSFields(){

        $fields = parent::getCMSFields();


        $fields->addFieldToTab("Root.ProfileInfo", new TextField("FirstName", "First Name"));
        $fields->addFieldToTab("Root.ProfileInfo", new TextField("Surname", "Surname"));
        $fields->addFieldToTab("Root.ProfileInfo", new TextField("JobTitle", "Job Title"));

        $fields->addFieldToTab("Root.ProfileInfo", new UploadField("ProfileImage", "Profile Image"));        

        $fields->addFieldToTab("Root.ProfileInfo", new TextField("ContactEmail", "Contact Email"));
        $fields->addFieldToTab("Root.ProfileInfo", new TextField("ContactNumber", "Contact Number"));

        $fields->addFieldToTab("Root.ProfileInfo", new HTMLEditorField("AboutMe", "About Me"));
             
        $gridFieldConfigs1 = GridFieldConfig_RecordEditor::create();
        $gridFieldConfigs1->addComponent(new GridFieldAddNewInlineButton());
        $gridFieldConfigs1->addComponent(new GridFieldEditableColumns());

        $grid1 = new GridField("Responiblities", "Responiblities", $this->Responiblities(), $gridFieldConfigs1);
        $grid1->getConfig()->removeComponentsByType(GridFieldAddNewButton::class);
        $grid1->getConfig()->getComponentByType(GridFieldEditableColumns::class)->setDisplayFields(array(

                "Title"    => array(
                    'title' => 'Title',
                    'callback' => function($record, $column, $grid) {
                        return TextField::create($column);
                    }
                ),
            )
        );
        $fields->addFieldToTab('Root.Responiblities', $grid1); 


        return $fields;
    }  

    private static $default_blocks = array(
        "Internal Banner Row"   => array(
            "BlockWidgetInternalBanner" => "No"
        ), 
        "Dynamic Staff Profile Row"   => array(
            "BlockWidgetStaffProfile" => "No"
        ),         
        "Full Width CTA Row"   => array(
            "BlockWidgetFullWidthCTA"  => "No"
        ),                                    
     );

}
class StaffPage_Controller extends PageController {

    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
