<?php
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\Tab;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\ORM\DataObject;

class SectorDetailPage extends Page {

    private static $singular_name = "Service Detail Page";

    private static $db = array(
        // "SubTitle"      => "Text",
        "Description"   => "HTMLText",
        // "Icon"          => "Enum(array('Construction','Repairs', 'Property'))",
        // "Colour"        => "Color",

    );

    // public function getDisplayIcon(){
    //     switch($this->Icon){
    //         case "Construction":
    //             return "images/icons/services/construction.svg";
    //         case "Repairs":
    //             return "images/icons/services/responsive-repairs.svg";
    //         case "Property":
    //             return "images/icons/services/property-dev.svg";
    //     }
    // }
    
    private static $has_one = array(
        "Image"         => Image::class,
        "FontAwsomeIcon" => FontAwsomeIcon::class,
    );

    private static $owns = [
        'Image',
    ];
    
    public function getCMSFields(){
        $fields = parent::getCMSFields();


        $fields->insertBefore(new Tab('Config', 'Config'), 'Search');


        // $fields->addFieldToTab("Root.Main", new TextField("SubTitle", "Sub Title"),'URLSegment');

        //Image Icon
        // $fields->addFieldToTab('Root.Config', new DropdownField(
        //       'Icon',
        //       'Icon',
        //       singleton('SectorDetailPage')->dbObject('Icon')->enumValues()
        // ));        

        // $fields->addFieldToTab("Root.Config", new ColorField("Colour", "Sector colour"));

        //Font awesome Icon
        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Config', $field);


        $fields->addFieldToTab("Root.Config", new UploadField("Image", "Listing Image"));
        $HTML = HTMLEditorField::create('Description', 'Description')
            ->setRows(8);
        $fields->addFieldToTab('Root.Config', $HTML);   

        return $fields;
    }

    private static $default_blocks = array(
        "Banner Row"   => array(
            "BlockWidgetInternalBanner"
        ),
        "Feature Text & Checklist Row"   => array(
            "BlockWidgetFeatureText" => "2",
            "BlockWidgetChecklist" => "1",
        ),
        "Multiple Text & Image Rows"   => array(
            "BlockWidgetTextImageRows"
        ),
        "Clients Carousel Row"   => array(
            "BlockWidgetClientsCarousel"
        ),
        "Full Width CTA Row"   => array(
            "BlockWidgetFullWidthCTA"
        ),                        
     );

}
class SectorDetailPage_Controller extends PageController {

    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
