<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use SilverStripe\Forms\Tab;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\DropdownField;
use TractorCow\Colorpicker\Forms\ColorField;

class CaseStudyHolderPage extends Page {

    private static $db = array(
    );

    private static $has_one = array(
    );

    private static $has_many = array(
    );    

    private static $allowed_children = array(
        "CaseStudyDetailPage"
    );

    private static $default_blocks = array(
        "Banner Row"   => array(
            "BlockWidgetInternalBanner"
        )      
    );

    public function getCategories(){
        $EventCategory = Categories::get()->sort("Title");
        return $EventCategory;
    }

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Items");
        $gridField = GridFieldConfig_RecordEditor::create();
        $gridField->addComponent(new GridFieldAddNewInlineButton());
        $gridField->addComponent(new GridFieldEditableColumns());
        $grid = new GridField("Categories", "Categories", Categories::get()->sort("Title"), $gridField);
        $grid->getConfig()->removeComponentsByType(GridFieldAddNewButton::class);
        $grid->getConfig()->getComponentByType(GridFieldEditableColumns::class)->setDisplayFields(array(

                "Title"    => array(
                    'title' => 'Title',
                    'callback' => function($record, $column, $grid) {
                        return TextField::create($column);
                    }
                )                           
            )
        );
        $fields->insertBefore(new Tab('Categories', $grid), 'Search');       
        return $fields;
    }

}
class CaseStudyHolderPage_Controller extends PageController {

    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
