<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Forms\TextField;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;

class GalleryImages extends DataObject {

    private static $singular_name = "Image";

    private static $db = array(
        "Title"         => "Varchar",
    );

    private static $has_one = array(
        "CaseStudyDetailPage"    => CaseStudyDetailPage::class,
        "Image"         => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    private static $summary_fields = array(
        "Title"             => "Title",
        "GridThumbnail"     => "Image",
    ); 

    public function getGridThumbnail(){
        return $this->Image()->Thumbnail(50,50);
    } 

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        $fields->removeByName("CaseStudyDetailPageID");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
        return $fields;
    }    
}
