<?php

use SilverStripe\Forms\TextField;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Assets\Image;
use SilverStripe\ORM\DataObject;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class BlockWidgetMainBannerItem extends DataObject
{
	private static $singular_name = "Main Banner Slide";

	private static $db = array(
		"Title"         => "Varchar(250)",
		"Subheading"    => "Varchar(250)",
		// "ImageQuote"    => "Varchar(250)",
		// "Content"    	=> "HTMLText",
		"ButtonText"    => "Varchar(20)",
		"Sort"     => "Int"
	);

	private static $default_sort = "Sort";

	private static $has_one = array(
		"Banner"        => BlockWidgetMainBanner::class,
		"Background"    => Image::class,
		// "Image"         => Image::class,
		"TargetPage"    => SiteTree::class
	);

	private static $owns = [
		// 'Image',
		'Background',
	];

	public function getElementID(){
		return $this->ClassName . '_' . $this->ID;
	}

	public function getCMSFields(){
		$fields = parent::getCMSFields();
		$fields->removeByName("BannerID");
		$fields->removeByName("Sort");
		$fields->removeByName("LinkTracking");
		$fields->removeByName("FileTracking");
				
		$fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
		$fields->addFieldToTab("Root.Main", new TextField("Subheading", "Subheading"));
		$fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));
		$fields->addFieldToTab("Root.Main", new UploadField("Background", "Background Image"));
		$fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "Target Page", Page::get()->sort("Title")->map()->toArray()));
		$target->setEmptyString("Select a target page");

		return $fields;
	}
}