<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Forms\TextField;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Assets\Image;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\View\Requirements;
use SilverStripe\AssetAdmin\Forms\UploadField;

use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig;

class BlockWidgetMainBanner extends PageBlock {

    private static $singular_name = "Main Banner Block ";

    private static $db = array(
        "Sort"     => "Int"
    );

    private static $default_sort = "Sort";

    private static $fullOnly = true;

    private static $customCSS = true;

    private static $allowed_page_types = array(
        "HomePage"
    );   

    private static $has_one = array(
        // "TargetPage" => SiteTree::class,
    );

    private static $has_many = array(
        "Slides"       => BlockWidgetMainBannerItem::class,
    );

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        $fields->removeByName("Slides");
        $fields->removeByName("Sort");
        $fields->removeByName("LinkTracking");
        $fields->removeByName("FileTracking");

        //Slides
        // if ($this->ID){
            $gridFieldConfig  = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
            $grid = new GridField("Slides", "Slides", $this->Slides(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Main", $grid);
        // }

        return $fields;
    }

    public function getCustomCSS(){
        $customCSS = array();
        $Slides = $this->Slides();
        foreach ($Slides as $Slide){
            $customCSS[$Slide->getElementID()] = array();
            $customCSS[$Slide->getElementID()][] = array(
                "Title" => $Slide->getElementID(),
                "CSS"   => "background-image: url({$Slide->Background()->URL});background-repeat: no-repeat;background-size: cover;",
            );
        }
        return $customCSS;
    }

    public function Output(){

        Requirements::set_force_js_to_bottom(true);
        return parent::Output();
    }
}
