<?php
class CustomisableForm_ControllerReCAPTCHAExtension extends CustomisableForm_ControllerExtension {

	private static $allowed_actions = array(
		"submitForm",
		"finished"
	);

	public function submitForm(){
		if (!isset($_REQUEST["g-recaptcha-response"]) || strlen($_REQUEST["g-recaptcha-response"]) == 0){
			return Controller::curr()->redirect($this->owner->Link() . 'finished');
		}
		$ReCaptcha = new ReCAPTCHAService();
		if (!$ReCaptcha->VerifyGReCAPTCHA($_REQUEST["g-recaptcha-response"], SiteConfig::current_site_config()->InvisibleReCAPTCHAID)){
			return Controller::curr()->redirect($this->owner->Link() . 'finished');
		}
		return parent::submitForm();
	}
}