<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\CheckboxField;
use SilverStripe\View\Requirements;

class CustomisableFormInvisibleRecaptchaExtension extends DataExtension {
	private static $db = array(
		"UseReCAPTCHA"      => "Boolean"
	);

	private static $defaults = array(
	       'UseReCAPTCHA' => true,
	);

	public function updateCMSFields(FieldList $fields){
		parent::updateCMSFields($fields); // TODO: Change the autogenerated stub
		$fields->addFieldToTab("Root.Spam Protection", new CheckboxField("UseReCAPTCHA", "Use ReCAPTCHA"));
	}

	//adds to last field of any form
    private static $default_fields = array(
        "RecaptchaFormField"   => array(
            "FormFields\RecaptchaFormField" => array( 
            ),
        ),
    );

	public function Output(){
		if ($this->owner->UseReCAPTCHA){
			Requirements::set_force_js_to_bottom(true);
			$jsLink = 'https://www.google.com/recaptcha/api.js?render=explicit&onload=onloadCallback';
			Requirements::javascript($jsLink);
			Requirements::javascript(RECAPTCHA_EXTENSION_DIR . '/javascript/init_recaptcha.js');
			Requirements::javascriptTemplate(RECAPTCHA_EXTENSION_DIR . '/javascript/recaptcha.js', array("FormID"   => $this->owner->ID));
		}
//		return parent::Output();
	}
}