<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\FieldList;

class CustomFormInvisibleRecaptchaSiteConfigExtension extends DataExtension {
	private static $db = array(
		"InvisibleReCAPTCHAID"       => "Varchar(255)",
		"InvisibleReCAPTCHAFrontID"  => "Varchar(255)"
	);

	public function updateCMSFields(FieldList $fields)
	{
		$fields->addFieldToTab("Root.RECAPTCHA", new TextField("InvisibleReCAPTCHAID", "Invisible ReCAPTCHA Site Key (secret)"));
		$fields->addFieldToTab("Root.RECAPTCHA", new TextField("InvisibleReCAPTCHAFrontID", "Invisible ReCAPTCHA Front End Site Key"));
		parent::updateCMSFields($fields); // TODO: Change the autogenerated stub
	}
}