<?php
namespace FormFields;

use FormFields\CustomisableFormField;
use SilverStripe\Forms\FileField;

class CustomisableUploadField extends CustomisableFormField
{
	private static $singular_name = "Upload Field";

	private static $db = array();

	private static $has_one = array(
	);

	private static $base_field_type = FileField::class;

	private static $table_name = 'CustomisableUploadField';
	

	private static $has_upload = true;

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		//this removes the float and position from unwanted fields
		$fields->removeByName("Icon");
		$fields->removeByName("Float");
		return $fields;
	}

	public function getCustomField(){
		 $field = parent::getCustomField();
		return $field;
	}

	public function parseValue($value){
//		$values contains $_FILES array data.
//		Parse into upload function and return array with absolute path and File Name.
		$return = array();
		$return["Path"]     = $value["tmp_name"];
		$return["Title"]    = $value["name"];
		return $return;
	}

	function doUpload($data, $value) {
		$file = $data['upload-your-file-here']; //auto assigned name of data field
		$content = file_get_contents($file['tmp_name']);
		// ... process content
	}
}

//$attachment = chunk_split(base64_encode(file_get_contents('attachment.zip')));