<?php
namespace FormFields;

use FormFields\CustomisableFormField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class CustomisableHTMLTextField extends CustomisableFormField
{
	private static $singular_name = "HTML Text Field";

	private static $db = array(
		"Content"	=> "HTMLText"
	);

	private static $has_one = array();

	private static $table_name = 'CustomisableHTMLTextField';
	

	public function getCMSFields(){
		$fields = parent::getCMSFields();

		$fields->removeByName("Label");
		$fields->removeByName("Length");
		$fields->removeByName("HideField");
		$fields->removeByName("Required");
		$fields->removeByName("PrerequisiteFieldID");
		
		$fields->addFieldToTab("Root.Main", new HtmlEditorField("Content", "Content"));
		return $fields;
	}
}