<?php
namespace FormFields;

use FormFields\CustomisableFormField;
use SilverStripe\Forms\CheckboxField;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
// use SilverStripe\Forms\GridField\GridFieldDataColumns;

class CustomisableFormOptionField extends CustomisableFormField
{
	private static $singular_name = "Optionset Field";

	private static $remove_from_list = true;

	private static $db = array();

	private static $has_one = array();

	private static $has_many = array(
		"Options"           => CustomisableFormOptionFieldItem::class,
		// "DependantFields"   => CustomisableFormField::class
	);

	// private static $base_field_type = CheckboxField::class;

	private static $table_name = 'CustomisableFormOptionField';

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Options");
		if($this->ID){
			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->removeComponentsByType(GridFieldDataColumns::class);
			$gridFieldConfig->addComponent(new GridFieldOrderableRows());
			$gridFieldConfig->addComponent(new GridFieldEditableColumns());
			$gridFieldConfig->addComponent(new GridFieldAddNewInlineButton());
			$gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);

			$grid = new GridField("Options", "Options", $this->Options(), $gridFieldConfig);
			$fields->addFieldToTab("Root.Main", $grid);
		}

		return $fields;
	}

	public function getCustomField(){
		$field = parent::getCustomField();
		return $field;
	}


	public function parseValue($value){
		if (count($value) == 0){
			return "Not Provided";
		}
		$response = array();
		foreach($value as $ID => $chosen){
			if ($chosenOption = $this->Options()->filter(array("ID" => $ID))->First()){
				$response[] = $chosenOption->Title;
			}
		}
		return implode(', ',$response);
	}
}