<?php
namespace FormFields;

use FormFields\CustomisableFormOptionField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\ORM\ArrayList;
use SilverStripe\View\ArrayData;
use SilverStripe\Forms\SelectField;

class CustomisableDropdownList extends CustomisableFormOptionField
{
	private static $singular_name = "Dropdown Field";

	private static $db = array();

	private static $table_name = 'CustomisableDropdownList';

	private static $remove_from_list = false;

	private static $base_field_type = DropdownField::class;

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Options");
		if ($this->ID){
			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->removeComponentsByType(GridFieldDataColumns::class);
			$gridFieldConfig->addComponent(new GridFieldOrderableRows());
			$gridFieldConfig->addComponent(new GridFieldEditableColumns());
			$gridFieldConfig->addComponent(new GridFieldAddNewInlineButton());
			$gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);


			$grid = new GridField("Options", "Options", $this->Options(), $gridFieldConfig);

//			$grid->getConfig()->getComponentByType('GridFieldEditableColumns')->setDisplayFields(array(
//				'Title'  => function($record, $column, $grid) {
//					return new TextField($column, "");
//				}
//			));
			$fields->addFieldToTab("Root.Main", $grid);
		}

		return $fields;
	}

	public function parseValue($value){
		if ($chosenOption = $this->Options()->filter(array("ID" => $value))->First()){
			return $chosenOption->Title;
		}
		return "Not Provided";
	}


	public function getCustomField(){
		// $field = parent::getCustomField(); //This calls getCustomField from CustomisableFormField
		$fieldType = $this->stat('base_field_type'); //gets SilverStripe\Forms\TextField
		$sourceData = $this->Options()->sort("Sort")->map("ID", "Title")->toArray();
		$field = new $fieldType($this->getDataFieldTitle(), $this->Title, $sourceData); //creates SilverStripe\Forms\TextField Object ()
		$field->setSource($sourceData);
		$field->setEmptyString($this->Title);
		if ($this->Required){
			$field->setAttribute("required", "required");
		}		
		return $field;
	}



}