<?php
namespace FormFields;
use FormFields\CustomisableFormOptionField;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\CheckboxField;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\ORM\ArrayList;
use SilverStripe\View\ArrayData;

class CustomisableCheckboxField extends CustomisableFormOptionField
{
	private static $singular_name = "Checkbox Field";

	private static $db = array(
		"HideFieldName"         => "Boolean",
	);

	private static $table_name = 'CustomisableCheckboxField';

	private static $remove_from_list = false;

	private static $base_field_type = CheckboxField::class;

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Options");
		$fields->removeByName("PrerequisiteFieldValues");
		if($this->ID){
			//this removes the float and position from unwanted fields
			$fields->removeByName("Icon");
			$fields->removeByName("Float");
			$fields->replaceField("HideFieldName", new CheckboxField("HideFieldName", "Hide this fields label"));
			
			//this gets the options
			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->removeComponentsByType(GridFieldDataColumns::class);
			$gridFieldConfig->addComponent(new GridFieldOrderableRows());
			$gridFieldConfig->addComponent(new GridFieldEditableColumns());
			$gridFieldConfig->addComponent(new GridFieldAddNewInlineButton());
			$gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);

			$grid = new GridField("Options", "Options", $this->Options(), $gridFieldConfig);
			$fields->addFieldToTab("Root.Main", $grid);
		}

		return $fields;
	}

	public function parseValue($value){
		if (count($value) == 0){
			return "Not Provided";
		}
		$response = array();
		foreach($value as $ID => $chosen){
			if ($chosenOption = $this->Options()->filter(array("ID" => $ID))->First()){
				$response[] = $chosenOption->Title;
			}
		}
		return implode(', ',$response);
	}

	public function getPrerequisiteField($fieldID){
		return "{$this->FieldTitle}_{$fieldID}";
	}

	public function getCustomField(){
		$fields = new ArrayList();
		foreach($this->Options()->sort("Sort") as $option){
			$fieldType = $this->stat('base_field_type'); //Field type
			$fieldTitle = $this->FieldTitle . "[{$option->ID}]"; //Title

			$CheckboxField = new $fieldType($fieldTitle, $option->Title, 0); //assign 
			if ($this->Required){
				$CheckboxField->setAttribute("required", "required"); //is it required?
			}			
			
			$field = new ArrayData(
				array(
					"Title"         => $option->Title,
					"CheckboxField" => $CheckboxField
				)
			);
			$fields->push($field);
		}
		return $fields;
	}


}