<?php
// namespace NewedgeMedia\CustomisableForm;
use SilverStripe\ORM\DataObject;

class CustomisableDropdownListItem extends DataObject
{
	private static $singular_name = "Dropdown Option";

	private static $db = array(
		"Title" => "Varchar",
		"Sort"  => "Int"
	);

	private static $default_sort = "Sort";

	private static $table_name = 'CustomisableDropdownListItem';
	

	private static $has_one = array(
		"DropdownField" => CustomisableDropdownList::class
	);

	private static $has_many = array();

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Sort");
		$fields->removeByName("DropdownFieldID");
		return $fields;
	}
}