<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Control\Controller;
use SilverStripe\ORM\ArrayList;
use SilverStripe\View\ArrayData;
use SilverStripe\Control\Email\Email;
use SilverStripe\Control\HTTPRequest;
use SilverStripe\Core\Injector\Injector;
use FormFields\CustomisableFormField;
use FormFields\BlockWidgetCustomisableForm;


class CustomisableForm_ControllerExtension extends DataExtension {
	private static $allowed_actions = array(
		"submitForm",
		"finished"
	);

	public function submitForm(){
		$postVars = Controller::curr()->getRequest()->postVars();
		
		$formFields = new ArrayList();
		$filesList = array();
		foreach($postVars as $field => $values){
			if ($formField = CustomisableFormField::get()->filter(array("FieldTitle" => $field))->First()){
				if (singleton($formField->ClassName)->stat("has_upload")){
					$file = $formField->parseValue($values);
					$filesList[$formField->FieldTitle] = $file;
					$newField = new ArrayData(
						array(
							"Title" => $formField->Title,
							"Value" => $file["Title"]
						)
					);
					$formFields->push($newField);
				} else {
					$newField = new ArrayData(
						array(
							"Title" => $formField->Title,
							"Value" => $formField->parseValue($values)
						)
					);
					$formFields->push($newField);
				}
			}
		}

		$formID = Controller::curr()->request->param('ID');
		if ($form = BlockWidgetCustomisableForm::get()->byID($formID)){
			$recipients = $form->Recipients();
			$From = $form->FromAddress;
			$Subject = $form->Subject;
			foreach($recipients as $recipient){
				$To = $recipient->EmailAddress;
				$data["ToName"] = $recipient->Name;
				$data["FormFields"] = $formFields;
				$email = new Email($From, $To, $Subject);
				//set template
				$email->setHTMLTemplate('Email\CustomisableFormEmail');
				$email->setData($data);
				if (count($filesList) > 0){
					foreach($filesList as $file){
						$attach = $email->addAttachment($file["Path"], $file["Title"]);
					}
				}
				$email->send();
			}

			$request = Injector::inst()->get(HTTPRequest::class);
       	 	$session = $request->getSession();			
			$session->set("MessageSent", $formID);

			// Session::set("FieldData", $formFields);
			if ($form->TargetPage()->ID > 0){
				return Controller::curr()->redirect($form->TargetPage()->Link());
			} else {
				return Controller::curr()->redirectBack();
			}
		} else {
			Controller::curr()->httpError(404, "Form Not Found");
		}
	}
}