<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;
use TractorCow\Colorpicker\Forms\ColorField;

class BlockWidgetClientsCarouselItems extends DataObject {

    private static $singular_name = "CTA Item";

    private static $db = array(
        "Title"             => "Varchar",
        "Sort"              => "Int",        
    );

    private static $default_sort = "Sort";
    
    private static $allowed_page_types = array(
    );

    private static $has_many = array(
    );

    private static $has_one = array(
        "BlockWidgetClientsCarousel" => BlockWidgetClientsCarousel::class,
        "Image"         => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("BlockWidgetClientsCarouselID");
        
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
       
        return $fields;
    }

}
