<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\TextField;

class BlockWidgetClientsCarousel extends PageBlock {

    private static $singular_name = "Clients Carousel Block";

    private static $db = array(
        // "BackgroundColour"  => "Color",
        "Title" => "Text"

    );

    private static $has_many = array(
        "Items" => BlockWidgetClientsCarouselItems::class,
    );

    private static $has_one = array(
        // "Image" => Image::class,     
    );
    
    private static $fullOnly = true;

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("Items");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        // $fields->addFieldToTab("Root.Main", new UploadField("Image", "Background Image"));
        // $fields->addFieldToTab("Root.Main", new ColorField("BackgroundColour", "Background Colour (Will use default if blank)"));         


        if ($this->ID > 0){
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Main", $grid);
        }                
        return $fields;
    }

}
