<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\DropdownField;

use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;

class BlockWidgetChecklist extends PageBlock {

    private static $singular_name = "Checklist Block";

    private static $db = array(
        "Title"     => "Text",
        "Sort"      => "Int",
    );

    private static $has_many = array(
        "Items" => "BlockWidgetChecklistItem"
    );

    // private static $fullOnly = true;

    private static $default_sort = "Sort";


    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("Items");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        if ($this->ID > 0){
            $gridFieldConfigs = GridFieldConfig_RecordEditor::create();
            $gridFieldConfigs->addComponent(new GridFieldAddNewInlineButton());
            $gridFieldConfigs->addComponent(new GridFieldEditableColumns());

            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfigs);
            $grid->getConfig()->removeComponentsByType(GridFieldAddNewButton::class);
            $grid->getConfig()->getComponentByType(GridFieldEditableColumns::class)->setDisplayFields(array(

                    "Title"    => array(
                        'title' => 'Title',
                        'callback' => function($record, $column, $grid) {
                            return TextField::create($column);
                        }
                    ),
                    "FontAwsomeIconID"    => array(
                        'title' => 'FontAwsomeIconID',
                        'callback' => function($record, $column, $grid) {
                            return DropdownField::create("FontAwsomeIconID", "FontAwsomeIcon", FontAwsomeIcon::get()->map('ID','Icon')->toArray());
                        }
                    ),                    
                )
            );
            $fields->addFieldToTab('Root.Main', $grid);  
        }          
        return $fields;
    }

    public function Output()
        {
    //      Requirements::css("themes/" . Config::inst()->get('SSViewer', 'theme') . "/css/.css");
    //      Requirements::javascript("themes/" . Config::inst()->get('SSViewer', 'theme') . "/javascript/.js");
            return parent::Output();
        }

}
