<?php

use SilverStripe\ORM\DataObject;
use SilverStripe\SiteConfig\SiteConfig;


class TestimonialsRecipient extends DataObject
{
	private static $singular_name = "Testimonials Submission Notification Recipient";

	private static $db = array(
		"Name"      => "Varchar(255)",
		"Email"     => "Varchar(255)"
	);

	private static $summary_fields = array(
		"Name",
		"Email"
	);

	private static $has_one = array(
		"SiteConfig"    => SiteConfig::class
	);

	private static $has_many = array();

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("SiteConfigID");
		return $fields;
	}
}