<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Control\Controller;
use SilverStripe\ORM\PaginatedList;

class BlockWidgetTestimonialsList extends PageBlock {

    private static $singular_name = " Testimonials List Block ";

    private static $db = array(
    );

    private static $fullOnly = false;

    private static $allowed_page_types = array(
        "TestimonialsPage"
    );

    private static $has_one = array(
    );

    private static $customCSS = true;

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        return $fields;
    }

    public function Output(){
        return parent::Output();
    }

    public function getApprovedTestimonials(){
        $request        =  Controller::curr()->getRequest();
        $testimonials   =  $this->PageBlockRow()->Page()->Testimonials()->filter(array("Approved"   => true));

        $TestimonialsList = new PaginatedList($testimonials, $request);
        $TestimonialsList->setPageLength(4);

        return $TestimonialsList;

    }

    public function getCustomCSS(){
//		get all the buttons
        $customCSS = array();
        $testimonials = $this->getApprovedTestimonials();
        foreach ($testimonials as $testimonial){
            $stars = (int)$testimonial->Rating;
            $stars++;
            $customCSS[$testimonial->getElementID()] = array();
            $customCSS[$testimonial->getElementID()][] = array(
                "Title" => $testimonial->getElementID() . ' .rating i:nth-child(n+' . $stars . ')',
                "CSS" => "display:none;",
            );
        }
        return $customCSS;
    }

}
