<?php

use SilverStripe\Admin\ModelAdmin;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;

class TestimonialsAdmin extends ModelAdmin {

	private static $managed_models = array(   //since 2.3.2
		'TestimonialItem'
	);

	private static $url_segment = 'testimonialsadmin'; // will be linked as /admin/products
	private static $menu_title = 'Testimonials';
    private static $menu_icon_class = 'fas fa-quote-right';



    public function getEditForm($id = null, $fields = null) {

        $form = parent::getEditForm($id, $fields);

        // Event specific settings
        if($this->modelClass == 'TestimonialItem') {

            $gridFieldName = $this->sanitiseClassName($this->modelClass);
            $gridField = $form->Fields()->fieldByName($gridFieldName);

            $config = $gridField->getConfig();

            // Configure 'Add New' button text
            $config->removeComponentsByType($config->getComponentByType(GridFieldAddNewButton::class));
            // $config->removeComponentsByType($config->getComponentByType('GridFieldDeleteAction'));

        }

        return $form;

    }    

}
