<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\ORM\DataObject;

class BlockWidgetQuoteCTAItems extends DataObject {

	private static $singular_name = "Quote";

    private static $db = array(
        "Title"             => "Varchar(50)",
        "Company"           => "Varchar(50)",
        "Content"           => "HTMLText",
        "ButtonText"        => "HTMLText",
        "BackgroundColour"  => "Color",
        "Sort"              => "Int",
    );

    private static $default_sort = "Sort";

    private static $defaults = array(
           'Title'      => "Enter a title in the CMS",
           'Content'    => "Eget aliquet nibh praesent.",         
           'ButtonText' => "Click here",        
           'BackgroundColour' => "da4755",        
    );

    private static $has_one = array(
        "BlockWidgetQuoteCTA"    => BlockWidgetQuoteCTA::class,
        "Image"                  => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields()
        {
            $fields = parent::getCMSFields();
            $fields->removeByName("Sort");
            $fields->removeByName("BlockWidgetQuoteCTAID");
            $fields->addFieldToTab("Root.Main", new TextField("Title", "Customer Name (Optional)"));
            $fields->addFieldToTab("Root.Main", new TextField("Company", "Company Name (Optinal)"));
            $fields->addFieldToTab("Root.Main", new TextField("Content", "Content"));
            $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));
            $fields->addFieldToTab("Root.Main", new ColorField ("BackgroundColour", "CTA background colour (optional)"));
            $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
            return $fields;
        }

}