<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\ToggleCompositeField;

class BlogPostExtension extends DataExtension {

	private static $db = array(
		"Summary"   => "Varchar(100)"
	);

    private static $default_blocks = array(
		"Banner Row"   => array(
			"BlockWidgetInternalBanner"
		),
		"Text and Categories"   => array(
			"BlockWidgetText"		=> "2",
			"BlockWidgetCategories" => "1"
		),
		"Image CTA row"   => array(
			"BlockWidgetImageCTA" => "1"
		),
		"Blog Pager row"   => array(
			"BlockWidgetBlogPager" => "2"
		),				
	);

	public function getBlogDate(){
		$postDate = $this->owner->PublishDate;
		// $Newdate = date('d.m.y',strtotime($postDate)); //18.10.18
		$Newdate = date('F d, Y',strtotime($postDate)); //September 13, 2018 
		return $Newdate;			   
	}
	public function updateCMSFields(FieldList $fields){
		//remove theme stuff you dont need
		// $fields->removeByName("Summary");
		$fields->removeByName("CustomSummary");

        $summary = HtmlEditorField::create('Summary', false);
        $summary->setRows(5);

        $summaryHolder = ToggleCompositeField::create(
            'CustomSummary',
            _t(__CLASS__ . '.CUSTOMSUMMARY', 'Add A Custom Summary'),
            [
                $summary,
            ]
        );
        $summaryHolder->setHeadingLevel(4);
        $summaryHolder->addExtraClass('custom-summary');
        $fields->addFieldToTab('Root.Main', $summaryHolder,'Content');		


		parent::updateCMSFields($fields); // TODO: Change the autogenerated stub
	}	
}