<?php

namespace NewedgeMedia\MenuManager;

use SilverStripe\ORM\DataObject;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use Page;
use Sheadawson\Linkable\Models\Link;
use Sheadawson\Linkable\Forms\LinkField;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\CheckboxField;

class MenuItem extends DataObject {
	private static $db = array(
		"Name"          => "Varchar(100)",
		"SortOrder"     => "Int",
		// "External"      => "Boolean",
		// "ExternalLink"      => "Text",
	);

    private static $table_name = 'MenuItem';
	

	// private static $default_sort = "SortOrder";

	private static $has_one = array(
		"Menu"              => Menu::class,
		"TargetPage"        => SiteTree::class,
		"ParentCategory"    => MenuCategory::class,
		// "AdvertImage"       => Image::class,
		// "AdvertImageLink"   => SiteTree::class
	);

	private static $has_many = array(
		"ChildCategories"   => MenuCategory::class
	);

    // private static $many_many = array(
    // 	"Product" => Product::class,
    // );	

	public function getCMSFields()
	{
		$fields = parent::getCMSFields(); // TODO: Change the autogenerated stub
		$fields->removeByName("MenuID");
		$fields->removeByName("SortOrder");
		$fields->removeByName("ParentCategoryID");
		$fields->removeByName("Advert");
		if ($this->ParentCategory()->ID > 0){
			$fields->removeByName("MenuID");
			$fields->removeByName("ChildCategories");
			$fields->removeByName("AdvertImageID");
			$fields->removeByName("AdvertImageLinkID");
			$fields->removeByName("Advert");
			$fields->removeByName("SortOrder");

		} else {
			$fields->removeByName("LinkTracking");
			$fields->removeByName("FileTracking");
			$fields->removeByName("SortOrder");
			$fields->removeByName("Advert");	
			$fields->removeByName("ChildCategories");	
					
			$gridFieldConfig  = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
			$gridfield = new GridField("ChildCategories", "ChildCategories", $this->ChildCategories(), $gridFieldConfig);
			$fields->addFieldToTab("Root.ChildItems", $gridfield);
	        // if ($this->ChildCategories()->count() == 1) {
	            // $gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);
	        // }

			// $fields->addFieldToTab("Root.Advert", new UploadField("AdvertImage", "Image"));
			// $fields->addFieldToTab("Root.Advert", new DropdownField("AdvertImageLinkID", "Target Page", Page::get()->map()->toArray()));
			// $fields->removeByName("Advert");		

		}
		$fields->addFieldToTab("Root.Main", new TextField("Name", "Title"));		
		$fields->replaceField("TargetPageID", new DropdownField("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
		// $fields->addFieldToTab('Root.Main', LinkField::create('TargetPageID', 'Link to page or file'));

		// $fields->addFieldToTab("Root.Main", new CheckboxField("External", "Disable TargetPage and enable external link"));		
		// $fields->addFieldToTab("Root.Main", new TextField("ExternalLink", "External Link"));		

		return $fields;
	}

    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    }
    public function canDelete($member = null, $context = array()){
        return true;
    }	
}