<?php

use SilverStripe\Forms\UploadField;
use SilverStripe\ORM\DataObject;
use SilverStripe\SiteConfig\SiteConfig;


class SocialMediaLink extends DataObject
{
	private static $singular_name = "Social Media Link";

	private static $db = array(
		"Title"         => "Varchar(50)",
		"Link"          => "Varchar(255)",
		"Icon"          => "Enum(array('Twitter','Facebook','LinkedIn'))",
		"SortOrder"     => "Int"
	);

	private static $has_one = array(
		"SiteConfig"    => SiteConfig::class,
	);

	public function getDisplayIcon(){
		switch($this->Icon){
			case "Facebook":
				return "fab fa-facebook-f";
			case "Twitter":
				return "fab fa-twitter";
			case "LinkedIn":
				return "fab fa-linkedin-in";													
		}
	}

	private static $has_many = array();

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("SortOrder");
		$fields->removeByName("SiteConfigID");
		$fields->removeByName("LinkTracking");
		$fields->removeByName("FileTracking");
		return $fields;
	}
    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    }
    public function canDelete($member = null, $context = array()){
        return true;
    }	
}