<?php
namespace NewedgeMedia\BlockBuilder;

use SilverStripe\Control\Controller;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\RequiredFields;
use SilverStripe\Forms\TextareaField;
use SilverStripe\Forms\CheckboxField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class PageBlock extends DataObject {
 
  
  private static $db = array(	
    "Name"              => 'Varchar(255)',
    "ShowTitle"         => 'Boolean',
    "OverrideWidth"     => "Enum(array('No','1','2','3'))",
    "SortOrder"         => 'Int'
  );

  // One-to-one relationship with gallery page
  private static $has_one = array(
    'PageBlockRow'  => PageBlockRow::class
  );

  private static $defaults = array(
    "ShowTitle" => true
  );

    private static $table_name = 'PageBlock';
    
    private static $allowed_page_types = array();

    private static $customCSS = false;

 
 // tidy up the CMS by not showing these fields
  public function getCMSFields() {
    $fields = parent::getCMSFields();
    $fields->removeFieldFromTab("Root.Main","PageID");
    $fields->removeFieldFromTab("Root.Main","SortOrder");
    $fields->removeByName("PageBlockRowID");
    $fields->replaceField("Content", new TextAreaField("Content"));
    $fields->addFieldToTab("Root.Main", new CheckboxField("ShowTitle"), "Title");
    if (!$this->ID || $this->config()->fullOnly || $this->owner->PageBlockRow()->PageBlocks()->Count() > 2){
        $fields->removeByName("OverrideWidth");
    }
    return $fields;
  }
    
    public function getTargetLink(){
        if ($this->TargetPageID > 0){
            return $this->TargetPage()->Link();
        } else {
            return $this->ExternalURL;
        }
    }

    public function getTargetLinkTitle(){
        if (strlen($this->TargetTitle) > 0){
            return $this->TargetTitle;
        } else {
            if ($this->TargetPageID > 0){
                return $this->TargetPage()->Title;
            }
            return "";
        }
    }
  
  // Tell the datagrid what fields to show in the table
   private static $summary_fields = array( 
	   'Name' => 'Name'
   );
   public function getCMSValidator() { 
      return new PageBlock_Validator(); 
    } 

    public function getValidator() { 
      return new PageBlock_Validator(); 
    } 

    public function Output(){
      return $this->renderWith("PageBlocks/{$this->ClassName}");
    }

    public function getColumnWidth($pos){
//        count siblings.
        if ($this->OverrideWidth != "No"){
            return $this->OverrideWidth;
        }
        $siblings = $this->PageBlockRow()->PageBlocks()->Count();
        switch($siblings){
            case "1":
                return 3;
                break;
            case "2":
                if ($pos == 1){
                    return "2";
                }
                return "1";
                break;
            case "3":
            default:
                return "1";
                break;
        }
    }

    public function getTotalWidths(){
        $siblings = $this->PageBlockRow()->PageBlocks();
        $total =0;
        if ($siblings->count() > 1){
            foreach($siblings as $sib){
                if ($sib->OverrideWidth != "No"){
                    $total += $sib->OverrideWidth;
                } else {
                    $total += 1;
                }
            }
        } else {
            if ($siblings->First()->OverrideWidth != "No"){
                $total = 3;
            } else {
                $total = 7;
            }
        }

        return $total;
    }

    public function getFullwidth(){
        return $this->config()->fullOnly ? true : false;
    }

    public function getCustomCSS(){
        return false;
    }

    public function getElementID(){
        return $this->ClassName . '_' . $this->ID;
    }

    public function getBlockPage(){
        return Controller::curr();
    }

    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    } 
    
    public function canDelete($member = null, $context = array()){
        return true;
    }     
}

class PageBlock_Validator extends RequiredFields { 
   function php($data) { 
      $bRet = parent::php($data);
        // if (empty($data['Name'])) { 
        //     $this->validationError('Name','Name is required',"required"); 
        //     $bRet = false; 
        // }

        // if (empty($data['Content'])) { 
        //  $this->validationError('Content','Content is required',"required"); 
        //  $bRet = false; 
        // }

        return $bRet; 
   } 
}