<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use Sheadawson\Linkable\Models\Link;
use Sheadawson\Linkable\Forms\LinkField;
use SilverStripe\Forms\LiteralField;
use SilverStripe\Forms\CheckboxField;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Assets\File;

class BlockWidgetVideoArea extends PageBlock {

    private static $singular_name = "Video Area Block";

    private static $db = array(
        // "MP4Link"           => "Text",
        // "WebM"              => "Text",
        "YouTube"           => "Text",
        "YouTubeEnable"     => "Boolean",
        "Info"              => "Text",        
        "Sort"              => "Int",
    );

    private static $default_sort = "Sort";

    private static $fullOnly = false;

    private static $allowed_page_types = array(
    );

    private static $has_one = array(
        "Video" => File::class
    );

    private static $owns = [
        "Video"
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");

        // $fields->addFieldToTab("Root.Main", new TextField("MP4Link", 'MP4 Link'));        
        // $fields->addFieldToTab("Root.Main", new TextField("WebM", 'WebM Link'));     
        $fields->addFieldToTab("Root.Main", new UploadField("Video", 'Video'));     

        $fields->addFieldToTab("Root.Main", new CheckboxField("YouTubeEnable", 'Enable YouTube'));        
        $fields->addFieldToTab("Root.Main", new TextField("YouTube", 'YouTube Link'));        
        $fields->addFieldToTab("Root.Main", new LiteralField("Info", 'To embed a YouTube video paste in the iframe src. A URL should look like this - https://www.youtube.com/embed/sGLq9OuF9Yg'));  

        return $fields;
    }

    public function Output()
        {
    //      Requirements::css("themes/" . Config::inst()->get('SSViewer', 'theme') . "/css/.css");
    //      Requirements::javascript("themes/" . Config::inst()->get('SSViewer', 'theme') . "/javascript/.js");
            return parent::Output();
        }

}
