<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\SiteConfig\SiteConfig;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;

class BlockWidgetTwinImage extends PageBlock {

	private static $db = array(
		'Title'         => 'Varchar(255)',
		"LeftImageText" => "Varchar(255)",
		"RightImageText"=> "Varchar(255)"
	);

    private static $table_name = 'BlockWidgetTwinImage';
	

	private static $has_one = array(
		"LeftImage"         => Image::class,
		"LeftImageTarget"   => SiteTree::class,
		"RightImage"        => Image::class,
		"RightImageTarget"  => SiteTree::class
	);

	private static $singular_name = "Twin Image Block";

	private static $has_many = array(
	);

	function getCMSFields() {
		$fields = parent::getCMSFields();
        $fields->removeByName("LinkTracking");
        $fields->removeByName("FileTracking");		
		$fields->addFieldToTab("Root.LeftImage", new TextField("LeftImageText", "Link Text"));
		$fields->addFieldToTab("Root.LeftImage", new TreeDropdownField("LeftImageTargetID", "Link Target", SiteTree::class));
		$fields->addFieldToTab("Root.LeftImage", new UploadField("LeftImage", "Image"));
		$fields->addFieldToTab("Root.RightImage", new TextField("RightImageText", "Link Text"));
		$fields->addFieldToTab("Root.RightImage", new TreeDropdownField("RightImageTargetID", "Link Target", SiteTree::class));
		$fields->addFieldToTab("Root.RightImage", new UploadField("RightImage", "Image"));
//		$fields->replaceField("Content", new HTMLEditorField("Content"));
		return $fields;
	}
}