<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Assets\Image;

use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;

class BlockWidgetImageGallery extends PageBlock
{
    private static $singular_name = "Image Gallery Block";

    private static $db = array(
        "Sort"     => "Int"
    );

    private static $fullOnly = false;

    private static $default_sort = "Sort";

    private static $allowed_page_types = array();

    private static $has_many = array(
        "Items"  => BlockWidgetImageGalleryItems::class
    );

    private static $has_one = array(
    );

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        $fields->removeByName("PageBlockRowID");
        $fields->removeByName("Items");
        $fields->removeByName("Sort");

        $gridFieldConfig = GridFieldConfig_RecordEditor::create();
        $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
        $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
        $fields->addFieldToTab("Root.Main", $grid);
        return $fields;
    }

    public function Output()
    {
        return parent::Output();
    }
}
?>