<?php
namespace App\Extensions;
use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use App\Models\Accreditation;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use UndefinedOffset\SortableGridField\Forms\GridFieldSortableRows;

class SiteConfigExtension extends DataExtension 
{
	private static $has_many = [
		'Accreditations' => Accreditation::class
	];

	private static $table_name = 'Accreditations';

	private static $singular_name = 'Accreditation';

	private static $plural_name = 'Accreditations';	

    public function updateCMSFields(FieldList $fields)
    {
    	$accreditationConfig = GridFieldConfig_RecordEditor::create();
    	$accreditationConfig->addComponent(new GridFieldSortableRows('SortOrder'));
    	$accreditationField = GridField::create('Accreditations', 'Accreditations', $this->owner->Accreditations(), $accreditationConfig);
    	$fields->addFieldToTab(
    		'Root.Accreditations', 
    		$accreditationField
    	);
    }	
}