<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class BlockWidgetTimelineCarouselItems extends DataObject {

    private static $singular_name = "Timeline Item";

    private static $db = array(
        "Title"     => "Varchar",
        "Date"      => "Varchar",
        "Content"   => "HTMLText",
        "Sort"      => "Int",
    );

    private static $default_sort = "Sort";
    
    private static $allowed_page_types = array(
    );

    private static $has_many = array(
    );

    private static $has_one = array(
        "BlockWidgetTimelineCarousel"   => "BlockWidgetTimelineCarousel",
        "Image"                         => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("BlockWidgetTimelineCarouselID");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new TextField("Date", "Date"));
        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
        $fields->addFieldToTab("Root.Main", new HTMLEditorField("Content", "Content"));
        return $fields;
    }

}
