<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;

class BlockWidgetImageTextCarouselItems extends DataObject {

    private static $singular_name = "Text Carousel Item";

    private static $db = array(
        "Title"     => "Varchar",
        "Content"   => "HTMLText",
        "Sort"      => "Int",
    );

    private static $default_sort = "Sort";
    
    private static $allowed_page_types = array(
    );

    private static $has_many = array(
    );

    private static $has_one = array(
        "BlockWidgetImageTextCarousel"      => BlockWidgetImageTextCarousel::class,
        "Image"                             => Image::class,
        "FontAwsomeIcon"                    => FontAwsomeIcon::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Main', $field); 

        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
        $fields->addFieldToTab("Root.Main", new HTMLEditorField("Content", "Content"));
        return $fields;
    }

}
