<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
class BlockWidgetTimelineCarousel extends PageBlock {

    private static $singular_name = "Timeline Carousel Block";

    private static $db = array(
        "Title" => "Varchar",
        "Content" => "HTMLText",        
        "Sort"     => "Int",
    );

    private static $fullOnly = true;

    private static $default_sort = "Sort";

    private static $has_many = array(
        "Items" => "BlockWidgetTimelineCarouselItems"
    );

    private static $has_one = array(
    );

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("Items");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new HTMLEditorField("Content", "Content"));

        if ($this->ID > 0){
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Timeline Items", $grid);
        }        
        return $fields;
    }

}
