<?php
namespace App\Models;
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\SiteConfig\SiteConfig;

class Accreditation extends DataObject 
{
	private static $db = [
		'Title' => 'Varchar', 
		'SortOrder' => 'Int'
	];

	private static $has_one = [
		'SiteConfig' => SiteConfig::class, 
		'Logo' => Image::class
	];

	private static $owns = [
		'Logo'
	];
	
	private static $default_sort = 'SortOrder';

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();

		$fields->removeFieldsFromTab(
			'Root.Main', 
			['SiteConfigID', 'SortOrder']
		);

		return $fields;
	}
}