<?php
    use SilverStripe\AssetAdmin\Forms\UploadField;
    use SilverStripe\Assets\Image;

    use SilverStripe\Forms\GridField\GridFieldConfig;
    use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
    use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
    use SilverStripe\Forms\GridField\GridField;
class CareersPage extends Page {

    private static $db = array(
    );

    private static $allowed_children = array(
        GenericPage::class,
    );

    private static $has_many = array(
        "Items" => JobVacancy::class
    );

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Items");
        if ($this->ID > 0){
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            // $gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Vacancies", $grid);
        }        
        return $fields;
    } 

    private static $default_blocks = array(
        "Banner Row"   => array(
            "BlockWidgetInternalBanner"
        ),
        "Vacancy Row"   => array(
            "BlockWidgetVacancyListing"
        ),                    
        "Contact Info Map Row"   => array(
            "BlockWidgetContactInfoMap"  => "No"
        ),            
        "Full Width CTA Row"   => array(
            "BlockWidgetFullWidthCTA"  => "No"
        ),                            
     );

}
class CareersPage_Controller extends PageController {

    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
